#include <p18f4520.h>
#include <delays.h>
#include <usart.h>
#include <adc.h>

#pragma config OSC 		= HS
#pragma config WDT      = OFF
#pragma config LVP      = OFF

void main(void){

unsigned int result = 0;

  // configure USART

  OpenUSART( USART_TX_INT_OFF  &
             USART_RX_INT_OFF  &
             USART_ASYNCH_MODE &
             USART_EIGHT_BIT   &
             USART_CONT_RX     &
             USART_BRGH_HIGH, 129);

  // configure A/D convertor

OpenADC(ADC_FOSC_32 & ADC_RIGHT_JUST & ADC_20_TAD, ADC_CH0 & 
ADC_INT_OFF & ADC_VREFPLUS_VDD & ADC_VREFMINUS_VSS, 0);

 

	while(1){
		Delay10TCYx( 5 ); // Delay for 50TCY
		ConvertADC(); // Start conversion
		while( BusyADC() ); // Wait for completion
		result = (ReadADC()/20); // Read result

		Delay10KTCYx(5);
		putcUSART( result );
	}


CloseADC(); // Disable A/D converter
CloseUSART();
}



