#include <p18f4520.h>
#include <delays.h>
#include <usart.h>

#pragma config OSC 		= HS
#pragma config WDT      = OFF
#pragma config LVP      = OFF

void InterruptHandlerHigh (void);

unsigned int data;

void main(void){
TRISD = 0x00;
PORTD = 0x00;

	//Setup Interrupts
RCON 	= 0b00000000; 
INTCON 	= 0b11000000;

  // configure USART
  OpenUSART( USART_TX_INT_OFF  &
             USART_RX_INT_ON  &
             USART_ASYNCH_MODE &
             USART_EIGHT_BIT   &
			 USART_CONT_RX     &
             USART_BRGH_HIGH, 129);

Delay10KTCYx(1);

	while(1){
		
			PORTD = 0x00;
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100);
			Delay100TCYx(100-(data));

			PORTD = 0xFF;
			Delay100TCYx(50+(data));
	}

CloseUSART();
}

//**BEGIN INTERRUPT CONTROL**
#pragma code InterruptVectorHigh = 0x08		//interrupt pointer address (0x08 high priority)
void InterruptVectorHigh (void)
{
        _asm						//assembly code starts
        goto InterruptHandlerHigh	//interrupt control
        _endasm						//assembly code ends
}

#pragma code
#pragma interrupt InterruptHandlerHigh		//end interrupt control

void InterruptHandlerHigh()		// Declaration of InterruptHandler
{	
        if(PIR1bits.RCIF){		
			data = ReadUSART();	
			PIR1bits.RCIF = 0;	//Clear RCIF Flag
        }
    INTCONbits.GIE = 1;						//Re-enable all interrupts
return;

}