library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

ENTITY counter_slow IS
PORT(clk : in BIT; 
     nums_out : out STD_LOGIC_VECTOR(7 DOWNTO 0);
	 P_input : in STD_LOGIC_VECTOR(3 DOWNTO 0);
	 LED_1 : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
	 LED_2 : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
	 DIR : IN STD_LOGIC);
end counter_slow;

ARCHITECTURE bhv OF counter_slow IS

SIGNAL O_buf : STD_LOGIC_VECTOR(7 DOWNTO 0);
SIGNAL U_four : STD_LOGIC_VECTOR(3 DOWNTO 0);
SIGNAL L_four : STD_LOGIC_VECTOR(3 DOWNTO 0);

BEGIN

PROCESS(clk)
variable cnt: integer range 0 to 25157000;
variable speed: integer range 0 to 25157000;
BEGIN
	CASE P_input IS
		WHEN "1111" =>
			speed := 25157000;	--0
		WHEN "1110" =>
			speed := 25157000/2;	--1
		WHEN "1101" =>
			speed := 25157000/4;	--2
		WHEN "1011" =>
			speed := 25157000/8;	--3
		WHEN "0111" =>
			speed := 25157000/16;	--4	
		WHEN "0000" =>
			speed := 25157000/32;	--4																								
		WHEN OTHERS =>
		speed := 25157000;			--15
	END CASE;
	
	if(clk'EVENT AND clk='1') THEN
		if(cnt = speed) THEN
		cnt := 0;
	
			if(DIR='1') THEN
				O_buf <= O_buf+1;
			else
				O_buf <= O_buf-1;
			end if;
		
		else
			cnt := cnt+1;
		end if;
	end if;
END PROCESS;

L_four(0) <= O_buf(0);
L_four(1) <= O_buf(1);
L_four(2) <= O_buf(2);
L_four(3) <= O_buf(3);

U_four(0) <= O_buf(4);
U_four(1) <= O_buf(5);
U_four(2) <= O_buf(6);
U_four(3) <= O_buf(7);

		--Upper 4 Bits
	WITH U_four SELECT
			--abcdefg
		LED_1 <= "00000011" WHEN "1111", -- 0
			 "10011111" WHEN "1110", -- 1
			 "00100101" WHEN "1101", -- 2
			 "00001101" WHEN "1100", -- 3
			 "10011001" WHEN "1011", -- 4
			 "01001001" WHEN "1010", -- 5
			 "01000001" WHEN "1001", -- 6
			 "00011111" WHEN "1000", -- 7
			 "00000001" WHEN "0111", -- 8
			 "00001001" WHEN "0110", -- 9
			 "00010001" WHEN "0101", -- A
			 "00000001" WHEN "0100", -- B
			 "01100011" WHEN "0011", -- C
			 "00000011" WHEN "0010", -- D
			 "01100001" WHEN "0001", -- E
			 "01110001" WHEN "0000", -- F
			 "00000011" WHEN OTHERS;

		--Lower 4 bits
	WITH L_four SELECT
			--abcdefg
		LED_2 <= "00000011" WHEN "1111", -- 0
			 "10011111" WHEN "1110", -- 1
			 "00100101" WHEN "1101", -- 2
			 "00001101" WHEN "1100", -- 3
			 "10011001" WHEN "1011", -- 4
			 "01001001" WHEN "1010", -- 5
			 "01000001" WHEN "1001", -- 6
			 "00011111" WHEN "1000", -- 7
			 "00000001" WHEN "0111", -- 8
			 "00001001" WHEN "0110", -- 9
			 "00010001" WHEN "0101", -- A
			 "00000001" WHEN "0100", -- B
			 "01100011" WHEN "0011", -- C
			 "00000011" WHEN "0010", -- D
			 "01100001" WHEN "0001", -- E
			 "01110001" WHEN "0000", -- F
			 "00000011" WHEN OTHERS;

nums_out <= O_buf;

end bhv;