LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY Project_1 IS
PORT (  
		--Used For The 4 Bit Adder
		CIN : IN STD_LOGIC;
		x0, x1, x2, x3 : IN STD_LOGIC;
		y0, y1, y2, y3 : IN STD_LOGIC;
		s0, s1, s2, s3 : OUT STD_LOGIC;
		COUT : OUT STD_LOGIC;
		
		--Used For The 7-Segment Display
		LED_2 : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
		LED_1 : OUT STD_LOGIC_VECTOR( 7 DOWNTO 0)
		);
END Project_1;

ARCHITECTURE behavior OF Project_1 IS
SIGNAL C1, C2, C3, S_Cout : STD_LOGIC;
SIGNAL S_Buffer : STD_LOGIC_VECTOR(3 DOWNTO 0);

COMPONENT fulladd
	PORT(CIN, x, y : IN STD_LOGIC;
		 s, COUT : OUT STD_LOGIC);
END COMPONENT;

BEGIN

	STAGE0 : FULLADD PORT MAP(CIN,X0,Y0,S_Buffer(0),C1);
	STAGE1 : FULLADD PORT MAP(C1,X1,Y1,S_Buffer(1),C2);
	STAGE2 : FULLADD PORT MAP(C2,X2,Y2,S_Buffer(2),C3);
	STAGE3 : FULLADD PORT MAP(C3,X3,Y3,S_Buffer(3),S_Cout);
	
	S0 <= S_Buffer(0);
	S1 <= S_Buffer(1);
	S2 <= S_Buffer(2);
	S3 <= S_Buffer(3); 
	COUT <= S_Cout;

	WITH S_Cout SELECT
		LED_1 <= "10011111" WHEN '0',
			"00000011" WHEN '1';

	WITH S_Buffer SELECT
			--abcdefg
		LED_2 <= "00000011" WHEN "1111", -- 0
			 "10011111" WHEN "1110", -- 1
			 "00100101" WHEN "1101", -- 2
			 "00001101" WHEN "1100", -- 3
			 "10011001" WHEN "1011", -- 4
			 "01001001" WHEN "1010", -- 5
			 "01000001" WHEN "1001", -- 6
			 "00011111" WHEN "1000", -- 7
			 "00000001" WHEN "0111", -- 8
			 "00001001" WHEN "0110", -- 9
			 "00010001" WHEN "0101", -- A
			 "00000001" WHEN "0100", -- B
			 "01100011" WHEN "0011", -- C
			 "00000011" WHEN "0010", -- D
			 "01100001" WHEN "0001", -- E
			 "01110001" WHEN "0000", -- F
			 "00000011" WHEN OTHERS;
		
END behavior;

LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY fulladd IS
PORT(CIN, x, y : IN STD_LOGIC;
	 s, COUT : OUT STD_LOGIC);	
END fulladd;

ARCHITECTURE structure OF fulladd IS
BEGIN
	s <= x XOR y XOR CIN;
	COUT <= (x AND y) OR (x AND CIN) or (y AND CIN);
END structure;
