--Please maintain this header statement
--     http://www.pyroelectro.com
--if you use this code. Thank You!!!!!
--Created by Chris @ PyroElectro.com
--
-- Don't Freak Out Because It's Called AD_CONVERTER.
-- I Just Used The Same Project Files For The ADC->CPLD
-- Article As This One!
--
	--Necessary Header Files
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;
USE IEEE.NUMERIC_STD.ALL;

	--Define The Core Entity
ENTITY AD_CONVERTER IS
PORT(   
		--25.175 MHz Clock
		CLK		: IN STD_LOGIC;
		
		--Analog To Digital Converter
		ADC_ENABLE  : OUT STD_LOGIC;
		ADC_INPUT	: IN STD_LOGIC_VECTOR(7 DOWNTO 0);
		MOTOR_EN		: OUT STD_LOGIC;
		
		--Output Display
		LED_OUTPUT	: OUT STD_LOGIC_VECTOR(9 DOWNTO 0));
end AD_CONVERTER;

	--Define The Architecture Of The Entity
ARCHITECTURE behavior of AD_CONVERTER IS

SIGNAL adc_value : STD_LOGIC_VECTOR(7 DOWNTO 0);		
		
BEGIN

PROCESS(CLK)
variable cnt: integer range 0 to 500000;

BEGIN

	IF(RISING_EDGE(CLK))THEN
-----------------------------------------
---- Pulse The MAX150 ADC To Update The Digital Output ------		
----------------------------------------- 		
		IF(cnt = 100000)THEN
			ADC_ENABLE <= '1';
			cnt := cnt + 1;
		ELSIF(cnt = 200000)THEN
			ADC_ENABLE <= '0';	
			cnt := cnt + 1;
		ELSIF(cnt = 300000)THEN
			ADC_ENABLE <= '1';
			cnt := cnt + 1;
		ELSIF(cnt = 400000)THEN
			adc_value <= ADC_INPUT;
			cnt := 0;
		ELSE
			cnt := cnt + 1;
		END IF;	
	END IF;
END PROCESS;

PROCESS(CLK)
variable clk_cnt : integer range 0 to 1000000;
variable pwm_cnt : integer range 0 to 1000;
variable direction : integer range 0 to 3;
BEGIN			

	MOTOR_EN <= '1';

	IF(RISING_EDGE(clk))THEN
		
	--A Much Better Way To Create PWM Using VHDL
		--PWM Going To The Motor: Differential Signal P
		IF(adc_value = x"00")THEN
				LED_OUTPUT(9) <= '1';							
				LED_OUTPUT(8) <= '0';
				LED_OUTPUT(7) <= '1';							
				LED_OUTPUT(6) <= '0';
				LED_OUTPUT(5) <= '1';							
				LED_OUTPUT(4) <= '0';
				LED_OUTPUT(3) <= '1';							
				LED_OUTPUT(2) <= '0';	
				LED_OUTPUT(1) <= '1';							
				LED_OUTPUT(0) <= '0';			
		ELSE
		--PWM Going To The Motor: Differential Signal N
			IF(pwm_cnt = 257-conv_integer(adc_value))THEN	
				pwm_cnt := pwm_cnt + 1;
				LED_OUTPUT(9) <= '0';			
				LED_OUTPUT(8) <= '1';
				LED_OUTPUT(7) <= '0';			
				LED_OUTPUT(6) <= '1';
				LED_OUTPUT(5) <= '0';			
				LED_OUTPUT(4) <= '1';
				LED_OUTPUT(3) <= '0';			
				LED_OUTPUT(2) <= '1';
				LED_OUTPUT(1) <= '0';			
				LED_OUTPUT(0) <= '1';
		--When 257 is reached, Reset everything.
			ELSIF(pwm_cnt = 257)THEN
				pwm_cnt := 0;
				LED_OUTPUT(9) <= '1';
				LED_OUTPUT(8) <= '0';
				LED_OUTPUT(7) <= '1';
				LED_OUTPUT(6) <= '0';
				LED_OUTPUT(5) <= '1';
				LED_OUTPUT(4) <= '0';
				LED_OUTPUT(3) <= '1';
				LED_OUTPUT(2) <= '0';
				LED_OUTPUT(1) <= '1';
				LED_OUTPUT(0) <= '0';			
			ELSE
				pwm_cnt := pwm_cnt + 1;
			END IF;
		END IF;
					
	END IF;
END PROCESS;

END behavior;