--Please maintain this header statement
--     http://www.pyroelectro.com
--if you use this code. Thank You!!!!!
--Created by Chris @ PyroElectro.com
--
-- Don't Freak Out Because It's Called AD_CONVERTER.
-- I Just Used The Same Project Files For The ADC->CPLD
-- Article As This One!
--
	--Necessary Header Files
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;
USE IEEE.NUMERIC_STD.ALL;

	--Define The Core Entity
ENTITY AD_CONVERTER IS
PORT(   
		--25.175 MHz Clock
		CLK		: IN STD_LOGIC;
			
		--Output Display
		LED_OUTPUT	: OUT STD_LOGIC_VECTOR(9 DOWNTO 0));
end AD_CONVERTER;

	--Define The Architecture Of The Entity
ARCHITECTURE behavior of AD_CONVERTER IS
		
type nums is array(0 to 31) of integer;
constant my_nums : nums := (
	0	=>		0,
	1	=>		2,
	2	=>		4,
	3	=>		6,
	4	=>		8,
	5	=>		10,
	6	=>		12,
	7	=>		15,
	8	=>		18,
	9	=>		21,
	10	=>		24,
	11	=>		28,
	12	=>		31,
	13	=>		34,
	14	=>		38,
	15	=>		42,
	16	=>		46,
	17	=>		51,
	18	=>		56,
	19	=>		61,
	20	=>		66,
	21	=>		72,
	22	=>		85,
	23	=>		93,
	24	=>		102,
	25	=>		112,
	26	=>		123,
	27	=>		137,
	28	=>		153,
	29	=>		174,
	30	=>		204,
	31	=>		255
);		
		
BEGIN

PROCESS(CLK)
variable clk_cnt : integer range 0 to 1000000;
variable pwm_cnt : integer range 0 to 1000;
variable int_cnt_0 : integer range 0 to 31;
variable direction : integer range 0 to 3;
BEGIN				

	IF(RISING_EDGE(clk))THEN

	--1 Period = 512 Clock Cycles
		--Nevative Duty Cycle
		IF(pwm_cnt = 256-my_nums(int_cnt_0))THEN
			pwm_cnt := pwm_cnt + 1;
			LED_OUTPUT(9 DOWNTO 5) <= "00000";
			LED_OUTPUT(4 DOWNTO 0) <= "11111";
		--Positive Duty Cycle
		ELSIF(pwm_cnt = 256+my_nums(int_cnt_0))THEN
			pwm_cnt := 0;
			LED_OUTPUT(9 DOWNTO 5) <= "11111";			
			LED_OUTPUT(4 DOWNTO 0) <= "00000";
		ELSE
			pwm_cnt := pwm_cnt + 1;
		END IF;
		
		--Clk_Cnt here will set how fast the LEDs fade in and out.
		IF(clk_cnt = 500000)THEN
		
			--Increment
			IF(direction = 0)THEN
				IF(int_cnt_0 = 31)THEN
					direction := 1;
				ELSE
					int_cnt_0 := int_cnt_0 + 1;
				END IF;	
					clk_cnt := 0;
			--Decrement
			ELSE
				IF(int_cnt_0 = 1)THEN
					direction := 0;
				ELSE
					int_cnt_0 := int_cnt_0 - 1;
				END IF;	
					clk_cnt := 0;			
			END IF;
					
		ELSE	
			clk_cnt := clk_cnt + 1;
		END IF;	
	
	END IF;
END PROCESS;

END behavior;