/* 
 *
 * Author: Chris @ PyroElectro.com
 *
 * Date: September 21, 2012, 8:50 AM
 *
 * Description:
 * This project is meant to control 16 LEDs that are in the shape of a heart
 * using PWM to allow for 6 sequences of patterns including some fading in and out.
 * A timer interrupt will be used to update PWM status for each individual LED at a
 * rate of about 80 Hz. 
 *
 * The 6 patterns that the LEDs should generate are:
 * [1] LED's 'Around The Heart' - Each LED in the heart lights up once one at a time.
 * [2] Total Heart Fade In-Out - The entire heart fades in and out at the same rate 5 times.
 * [3] Wave-Like Fade, Bottom to Top - Each row of LEDs has a different brightness 'moving' upward
 * [4] Wave-Like Fade, Right to Left - Each column of LEDs has a different brightness 'moving' left
 * [5] Single Row Fading - With all other LEDs off, each row is faded in and out, one at a time.
 * [6] Single Column Fading - With all other LEDs off, each column is faded in and out, ont at a time.
 * *Rinse and Repeat back to 1, again and again*
 *
 * This isn't the most beautiful code that I've ever written given that I was in a time crunch and only
 * doing this for fun, so if you have questions about what's going on where, please go over to the forums
 * and ask them there: http://www.pyroelectro.com/forums/
 *
 * Project Webpage:
 * http://www.pyroelectro.com/projects/led_heart_led_fading/
 */

#include <p18f252.h>
#include <delays.h>
#include <timers.h>

#pragma config OSC = HS
#pragma config WDT = OFF
#pragma config LVP = OFF

void InterruptHandlerHigh(void);
void LED_Offset(unsigned int,unsigned int,unsigned int,unsigned int,
                unsigned int,unsigned int,unsigned int,unsigned int,
                unsigned int,unsigned int,unsigned int,unsigned int,
                unsigned int,unsigned int,unsigned int,unsigned int);
unsigned int count = 0;

unsigned int led_array[16] = {  0,0,0,0,
                                0,0,0,0,
                                0,0,0,0,
                                0,0,0,0 };

unsigned int    led_offset_array[16] = {0,0,0,0,
                                        0,0,0,0,
                                        0,0,0,0,
                                        0,0,0,0};

/*
 * 
 */
void main(){

unsigned int cnt = 0, i =0, wait=0;
    
    //All Outputs
TRISA = 0x00;
TRISB = 0x00;
TRISC = 0x00;
    //All 0's Initially
PORTA = 0x00;
PORTB = 0x00;
PORTC = 0x00;

//ALL LEDs OFF
for(i=0;i<16;i++){
     led_array[i]=0;
}

INTCONbits.GIE = 1;

OpenTimer0( TIMER_INT_ON & T0_16BIT & T0_SOURCE_INT & T0_PS_1_1 );

WriteTimer0(0xFF00);

//Let Timers And System Get All Setup
Delay10KTCYx(100);


//Run Through The 6 Different
    //LED Display Modes Forever And Ever
        //Bwahahahaha!!!
while(1){

/****MODE 1------MODE 1-------MODE 1--------MODE 1*****/

/*
 * 'All Around The Heart' LED Display
 *
 * In this part, the LEDs will light up one at a time
 * LED1 to LED16, thus creating an all around the world
 * feeling since all leds get lit up once during a cycle.
 *
 *  */

//ALL LEDs OFF
for(i=0;i<16;i++){
     led_array[i]=0;
}

Delay10KTCYx(100);

//Initialize First Value
led_array[0]=50;
Delay10KTCYx(50);
//Let For Loop Do The Rest
for(i=1;i<16;i++){
        //Set New LED On
     led_array[i]=50;
        //Set Old LED Off
     led_array[i-1]=0;
     Delay10KTCYx(30);
}
led_array[15]=0;

//Initialize First Value
led_array[0]=50;
Delay10KTCYx(50);
//Let For Loop Do The Rest
for(i=1;i<16;i++){
        //Set New LED On
     led_array[i]=50;
        //Set Old LED Off
     led_array[i-1]=0;
     Delay10KTCYx(30);
}
led_array[15]=0;

/******************************************************/


Delay10KTCYx(10);

/****MODE 2------MODE 2-------MODE 2--------MODE 2*****/

/*
 *  FADE The Whole Heart In And Out
 *
 **/

LED_Offset( 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

for(wait=0;wait<5;wait++){
     for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }
}
    //Fade Back On For Ending
     for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

/******************************************************/

Delay10KTCYx(10);

/****MODE 3------MODE 3-------MODE 3--------MODE 3*****/
/*
 *  FADE Row By Row
 *
 **/

LED_Offset( 0,0,5,5,5,5,5,12,12,12,12,12,17,17,17,24 );

for(wait=0;wait<5;wait++){
    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }
}

/*******************************************************/

Delay10KTCYx(10);
//ALL LEDs ON
for(i=0;i<16;i++){
     led_array[i]=30;
}

/****MODE 4------MODE 4-------MODE 4--------MODE 4*****/

/*
 *  FADE Column By Column
 *
 **/
LED_Offset(5,17,0,5,12,17,24,0,5,12,17,24,5,12,17,12);
for(wait=0;wait<5;wait++){
    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }
}
/*******************************************************/

        Delay10KTCYx(10);

/****MODE 5------MODE 5-------MODE 5--------MODE 5*****/
/* Row By Row Single Lights */

/*
 *  FADE Column By Column
 *
 **/

//ALL LEDs ON
for(i=0;i<16;i++){
     led_array[i]=30;
}

LED_Offset(0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0);
//Row 1
     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<2;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[0] = 0;
led_array[1] = 0;

//Row 2
     for(cnt=30;cnt>=1;cnt--){
         for(i=2;i<7;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[2] = 0;
led_array[3] = 0;
led_array[4] = 0;
led_array[5] = 0;
led_array[6] = 0;

//Row 3
     for(cnt=30;cnt>=1;cnt--){
         for(i=7;i<12;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }


led_array[7] = 0;
led_array[8] = 0;
led_array[9] = 0;
led_array[10] = 0;
led_array[11] = 0;

//Row 4
     for(cnt=30;cnt>=1;cnt--){
         for(i=12;i<15;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[12] = 0;
led_array[13] = 0;
led_array[14] = 0;

//Row 5
     for(cnt=30;cnt>=1;cnt--){
         for(i=15;i<16;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[15] = 0;

//Row 5

    for(cnt=1;cnt<=30;cnt++){

         for(i=15;i<16;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=15;i<16;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[15] = 0;

//Row 4

    for(cnt=1;cnt<=30;cnt++){

         for(i=12;i<15;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=12;i<15;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[12] = 0;
led_array[13] = 0;
led_array[14] = 0;


//Row 3

    for(cnt=1;cnt<=30;cnt++){

         for(i=7;i<12;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=7;i<12;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }


led_array[7] = 0;
led_array[8] = 0;
led_array[9] = 0;
led_array[10] = 0;
led_array[11] = 0;


//Row 2

    for(cnt=1;cnt<=30;cnt++){

         for(i=2;i<7;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=2;i<7;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[2] = 0;
led_array[3] = 0;
led_array[4] = 0;
led_array[5] = 0;
led_array[6] = 0;

//Row 1
    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<2;i++){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<2;i++){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         Delay10KTCYx(3);
     }

led_array[0] = 0;
led_array[1] = 0;

/*******************************************************/

Delay10KTCYx(10);

/****MODE 6------MODE 6-------MODE 6--------MODE 6*****/
/* Column By Column Full Row Fade-In/Out Lights */

LED_Offset(0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0);
//Column 1
    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
         if(i==2 || i==7){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==2 || i==7){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }

led_array[2] = 0;
led_array[7] = 0;

//Column 2

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
            if(i==0 || i==3 || i==8 || i==12){
             if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==0 || i==3 || i==8 || i==12){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }


led_array[0] = 0;
led_array[3] = 0;
led_array[8] = 0;
led_array[12] = 0;

//Column 3

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
           if(i==4 || i==9 || i==13 || i==15){         
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==4 || i==9 || i==13 || i==15){       
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }


led_array[4] = 0;
led_array[9] = 0;
led_array[13] = 0;
led_array[15] = 0;

//Column 4

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
         if(i==1 || i==5 || i==10 || i==14){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
         }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){        
         for(i=0;i<16;i++){
             if(i==1 || i==5 || i==10 || i==14){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         }
         Delay10KTCYx(3);
     }

led_array[1] = 0;
led_array[5] = 0;
led_array[10] = 0;
led_array[14] = 0;

//Column 5

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
             if(i==6 || i==11){

            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
             }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==6 || i==11){

             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }
     
led_array[6] = 0;
led_array[11] = 0;

//Column 5

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
             if(i==6 || i==11){

            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
             }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==6 || i==11){

             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }
  
led_array[6] = 0;
led_array[11] = 0;

//Column 4

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
         if(i==1 || i==5 || i==10 || i==14){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
         }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){     
         for(i=0;i<16;i++){
             if(i==1 || i==5 || i==10 || i==14){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
         }
         }
         Delay10KTCYx(3);
     }

led_array[1] = 0;
led_array[5] = 0;
led_array[10] = 0;
led_array[14] = 0;

//Column 3

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
           if(i==4 || i==9 || i==13 || i==15){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==4 || i==9 || i==13 || i==15){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }


led_array[4] = 0;
led_array[9] = 0;
led_array[13] = 0;
led_array[15] = 0;

//Column 2

    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
            if(i==0 || i==3 || i==8 || i==12){
             if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==0 || i==3 || i==8 || i==12){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }
     

led_array[0] = 0;
led_array[3] = 0;
led_array[8] = 0;
led_array[12] = 0;

//Column 1
    for(cnt=1;cnt<=30;cnt++){

         for(i=0;i<16;i++){
         if(i==2 || i==7){
            if(cnt+led_offset_array[i] > 30)
                if(60 - ((led_offset_array[i]+cnt)) < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = 60 - ((led_offset_array[i]+cnt));
            else{
                if(led_array[i] = led_offset_array[i]+cnt < 1)
                    led_array[i] = 1;
                else
                    led_array[i] = led_offset_array[i]+cnt;
            }
            }
          }
         Delay10KTCYx(3);
     }

     for(cnt=30;cnt>=1;cnt--){
         for(i=0;i<16;i++){
             if(i==2 || i==7){
             if((signed)cnt-(signed)led_offset_array[i] > 0){
                 if(cnt-led_offset_array[i] < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = cnt-led_offset_array[i];
             }
             else{
                 if(led_offset_array[i]-cnt < 1)
                     led_array[i] = 1;
                 else
                    led_array[i] = led_offset_array[i]-cnt;
             }
             }
         }
         Delay10KTCYx(3);
     }

led_array[2] = 0;
led_array[7] = 0;


/*******************************************************/


Delay10KTCYx(10);

}
}

//Interrupt Control
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
    _asm
    goto InterruptHandlerHigh
    _endasm
}
#pragma code
#pragma interrupt InterruptHandlerHigh

void InterruptHandlerHigh()
{

    unsigned int porta_buffer = 0;
    unsigned int portb_buffer = 0;
    unsigned int portc_buffer = 0;

    if(INTCONbits.TMR0IF)
    {
        count++;
        if(count >= 100)
            count = 0;
//Modify LED 1 Status
        if(count <= led_array[0] && led_array[0] > 0)
            porta_buffer |= 0x01; 
        else
            porta_buffer &= 0xFE; 
//Modify LED 2 Status
        if(count <= led_array[1] && led_array[1] > 0)
            portc_buffer |= 0x04; 
        else
            portc_buffer &= 0xFB; 
//Modify LED 3 Status
        if(count <= led_array[2] && led_array[2] > 0)
            porta_buffer |= 0x04; 
        else
            porta_buffer &= 0x0B; 
//Modify LED 4 Status
        if(count <= led_array[3] && led_array[3] > 0)
            porta_buffer |= 0x02;
        else
            porta_buffer &= 0xFD;
//Modify LED 5 Status
        if(count <= led_array[4] && led_array[4] > 0)
            portc_buffer |= 0x08;
        else
            portc_buffer &= 0xF7;
//Modify LED 6 Status
        if(count <= led_array[5] && led_array[5] > 0)
            portc_buffer |= 0x02; //PORTCbits.RC2 = 1;
        else
            portc_buffer &= 0xFD; //PORTCbits.RC2 = 0;
//Modify LED 7 Status
        if(count <= led_array[6] && led_array[6] > 0)
            portc_buffer |= 0x01; //PORTCbits.RC3 = 1;
        else
            portc_buffer &= 0xFE; //PORTCbits.RC3 = 0;
//Modify LED 8 Status
        if(count <= led_array[7] && led_array[7] > 0)
            portb_buffer |= 0x01; //PORTCbits.RC4 = 1;
        else
            portb_buffer &= 0xFE; //PORTCbits.RC4 = 0;
//Modify LED 9 Status
        if(count <= led_array[8] && led_array[8] > 0)
            portb_buffer |= 0x02; //PORTCbits.RC5 = 1;
        else
            portb_buffer &= 0xFD; //PORTCbits.RC5 = 0;
//Modify LED 10 Status
        if(count <= led_array[9] && led_array[9] > 0)
            portc_buffer |= 0x10; //PORTCbits.RC6 = 1;
        else
            portc_buffer &= 0xEF; PORTCbits.RC6 = 0;
//Modify LED 11 Status
        if(count <= led_array[10] && led_array[10] > 0)
            portc_buffer |= 0x40; //PORTCbits.RC7 = 1;
        else
            portc_buffer &= 0xBF; //PORTCbits.RC7 = 0;
//Modify LED 12 Status
        if(count <= led_array[11] && led_array[11] > 0)
            portc_buffer |= 0x80; //PORTBbits.RB0 = 1;
        else
            portc_buffer &= 0x7F; //PORTBbits.RB0 = 0;
//Modify LED 13 Status
        if(count <= led_array[12] && led_array[12] > 0)
            portb_buffer |= 0x04; //PORTBbits.RB1 = 1;
        else
            portb_buffer &= 0xFB; //PORTBbits.RB1 = 0;
//Modify LED 14 Status
        if(count <= led_array[13] && led_array[13] > 0)
            portb_buffer |= 0x10; //PORTBbits.RB2 = 1;
        else
            portb_buffer &= 0xEF; //PORTBbits.RB2 = 0;
//Modify LED 15 Status
        if(count <= led_array[14] && led_array[14] > 0)
            portc_buffer |= 0x20; //PORTBbits.RB3 = 1;
        else
            portc_buffer &= 0xDF; //PORTBbits.RB3 = 0;
//Modify LED 16 Status
        if(count <= led_array[15] && led_array[15] > 0)
            portb_buffer |= 0x08; //PORTBbits.RB4 = 1;
        else
            portb_buffer &= 0xF7; //PORTBbits.RB4 = 0;

        PORTA = porta_buffer;
        PORTB = portb_buffer;
        PORTC = portc_buffer;

        WriteTimer0(0xFF00);

        INTCONbits.TMR0IF = 0;
    }
INTCONbits.GIE = 1;
}

void LED_Offset(unsigned int a,unsigned int b,unsigned int c,unsigned int d,
                unsigned int e,unsigned int f,unsigned int g,unsigned int h,
                unsigned int i,unsigned int j,unsigned int k,unsigned int l,
                unsigned int m,unsigned int n,unsigned int o,unsigned int p){
    led_offset_array[0] = a;
    led_offset_array[1] = b;
    led_offset_array[2] = c;
    led_offset_array[3] = d;
    led_offset_array[4] = e;
    led_offset_array[5] = f;
    led_offset_array[6] = g;
    led_offset_array[7] = h;
    led_offset_array[8] = i;
    led_offset_array[9] = j;
    led_offset_array[10] = k;
    led_offset_array[11] = l;
    led_offset_array[12] = m;
    led_offset_array[13] = n;
    led_offset_array[14] = o;
    led_offset_array[15] = p;
}
